package inc.monsters.mias;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import javax.faces.context.FacesContext;

import org.apache.commons.digester.Digester;
import org.xml.sax.SAXException;

public class FaceletsFunctions {

	private static final Logger log = Logger.getLogger("inc.monsters.mias");
	private static Quote lastQuote;
	private static Quotes quotesList;
	private static List<Country> countries;
	
    public static String[] getStringArray(String string) {
    	return string.split(" ");
    }

	
	private static void readQuotesXMLFile() {
		Digester digester = new Digester();
		digester.setValidating(false);

		digester.addObjectCreate("quotes", Quotes.class);
		digester.addObjectCreate("quotes/quote", Quote.class);
		digester.addBeanPropertySetter("quotes/quote/text", "text");
		digester.addBeanPropertySetter("quotes/quote/author", "author");
		digester.addSetNext( "quotes/quote", "addQuote" );

		FacesContext context = FacesContext.getCurrentInstance();
		URL url;
		try {
			url = context.getExternalContext().getResource("/quotes.xml");
			quotesList = (Quotes) digester.parse(url);
		} catch (MalformedURLException e) {
			System.out.println("Quotes file could not be found. Malformed URL: " + e.getMessage());
		} catch (IOException e) {
			System.out.println("Quotes file could not be opened. IO Exception: " + e.getMessage());
		} catch (SAXException e) {
			System.out.println("Quotes file could not be read. Sax Exception: " + e.getMessage());
		} finally {
			digester = null;
		}
		if (quotesList == null) {
			quotesList = new Quotes();
		}
	}

	private static Quotes getQuotes() {
		if (quotesList == null) {
			readQuotesXMLFile();
		}
		return quotesList;
	}

	public static String getQuoteOfTheDay() {
		lastQuote = getQuotes().getRandomQuote();
		return lastQuote.getText();
	}

	public static String getAuthorOfTheDay() {
		return lastQuote.getAuthor();
	}
	
	public static List<Country> getCountries() {
		if (countries == null) {
			readCountriesXMLFile();
		}
		return countries;
	}
	
	@SuppressWarnings("unchecked")
	private static void readCountriesXMLFile() {
		log.fine("readCountriesXMLFile() called");
		Digester digester = new Digester();
		digester.setValidating(false);

		digester.addObjectCreate("ISO_3166-1_List_en", ArrayList.class);
		digester.addObjectCreate("ISO_3166-1_List_en/ISO_3166-1_Entry", Country.class);
		digester.addBeanPropertySetter("ISO_3166-1_List_en/ISO_3166-1_Entry/ISO_3166-1_Country_name", "name");
		digester.addBeanPropertySetter("ISO_3166-1_List_en/ISO_3166-1_Entry/ISO_3166-1_Alpha-2_Code_element", "code");
		digester.addSetNext( "ISO_3166-1_List_en/ISO_3166-1_Entry", "add");

		FacesContext context = FacesContext.getCurrentInstance();
		URL url;
		try {
			url = context.getExternalContext().getResource("/iso_3166-1_list_en.xml");
			log.fine("Countries URL: " + url);
			countries = (List<Country>) digester.parse(url);
			log.fine("Countries: " + countries.size());
		} catch (MalformedURLException e) {
			System.out.println("Countries file could not be found. Malformed URL: " + e.getMessage());
		} catch (IOException e) {
			System.out.println("Countries file could not be opened. IO Exception: " + e.getMessage());
		} catch (SAXException e) {
			System.out.println("Countries file could not be read. Sax Exception: " + e.getMessage());
		} finally {
			digester = null;
		}
		if (countries == null) {
			countries = new ArrayList<Country>();
		}
	}

}
